<?php
include '../includes/db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['video_file']) && isset($_FILES['thumbnail_file'])) {

    $title = $conn->real_escape_string($_POST['title']);
    $category_id = intval($_POST['category_id']);

    // ভিডিও ফাইলের তথ্য
    $video_file_name = basename($_FILES["video_file"]["name"]);
    $video_target_dir = "../uploads/";
    $video_target_file = $video_target_dir . $video_file_name;

    // থাম্বনেইল ফাইলের তথ্য
    $thumb_file_name = basename($_FILES["thumbnail_file"]["name"]);
    $thumb_target_dir = "../uploads/thumbnails/";
    $thumb_target_file = $thumb_target_dir . $thumb_file_name;
    $thumb_file_type = strtolower(pathinfo($thumb_target_file, PATHINFO_EXTENSION));

    // --- থাম্বনেইল ভ্যালিডেশন ---
    $check = getimagesize($_FILES["thumbnail_file"]["tmp_name"]);
    if($check === false) {
        echo "ত্রুটি: থাম্বনেইলটি একটি ছবি নয়।";
        exit();
    }
    if($thumb_file_type != "jpg" && $thumb_file_type != "png" && $thumb_file_type != "jpeg" && $thumb_file_type != "gif" ) {
        echo "দুঃখিত, শুধুমাত্র JPG, JPEG, PNG ও GIF ফরম্যাটের ছবি আপলোড করা যাবে।";
        exit();
    }

    // --- ভিডিও এবং থাম্বনেইল আপলোড ---
    $video_uploaded = false;
    $thumb_uploaded = false;

    if (move_uploaded_file($_FILES["video_file"]["tmp_name"], $video_target_file)) {
        $video_uploaded = true;
        if(move_uploaded_file($_FILES["thumbnail_file"]["tmp_name"], $thumb_target_file)) {
            $thumb_uploaded = true;
        } else {
            unlink($video_target_file); 
            echo "দুঃখিত, থাম্বনেইল আপলোডের সময় একটি ত্রুটি হয়েছে।";
            exit();
        }
    } else {
        echo "দুঃখিত, ভিডিও ফাইল আপলোডের সময় একটি ত্রুটি হয়েছে।";
        exit();
    }

    // --- ডেটাবেসে তথ্য সংরক্ষণ ---
    if ($video_uploaded && $thumb_uploaded) {
        
        // --- নতুন অপটিমাইজেশন কোড ---
        $original_video_path = $video_target_file;
        $optimized_video_name = "opt_" . pathinfo($video_file_name, PATHINFO_FILENAME) . ".mp4";
        $optimized_video_path = $video_target_dir . $optimized_video_name;

        // FFmpeg কমান্ড চালিয়ে ভিডিওর মেটাডেটা (moov atom) ফাইলের শুরুতে আনা
        $command = "ffmpeg -i " . escapeshellarg($original_video_path) . " -movflags +faststart -acodec copy -vcodec copy " . escapeshellarg($optimized_video_path);
        
        shell_exec($command);

        if (file_exists($optimized_video_path) && filesize($optimized_video_path) > 0) {
            unlink($original_video_path); 
            $video_path_db = "uploads/" . $optimized_video_name;
        } else {
            $video_path_db = "uploads/" . $video_file_name;
        }
        // --- অপটিমাইজেশন কোড শেষ ---

        $thumb_path_db = "uploads/thumbnails/" . $thumb_file_name;

        $sql = "INSERT INTO videos (title, file_path, thumbnail_path, category_id) VALUES ('$title', '$video_path_db', '$thumb_path_db', $category_id)";
        
        if ($conn->query($sql) === TRUE) {
            echo "ভিডিও এবং থাম্বনেইল সফলভাবে আপলোড হয়েছে।";
        } else {
            unlink($video_target_file);
            unlink($thumb_target_file);
            if(file_exists($optimized_video_path)) unlink($optimized_video_path);
            echo "ডেটাবেসে তথ্য সংরক্ষণে ত্রুটি হয়েছে: " . $conn->error;
        }
    }

} else {
    echo "অবৈধ অনুরোধ। অনুগ্রহ করে ভিডিও এবং থাম্বনেইল উভয়ই সিলেক্ট করুন।";
}

$conn->close();
?>